/*---------------------------------------------------------*/
/*  1-10V aquarium dimming                                 */
/* using 						    */
/*	arduino board				            */
/*	DS1307 clock					    */
/*	2-channel DAC					    */
/*---------------------------------------------------------*/

//for math functions used to produce random cloud effects
//#include "math.h"



//#define DEBUG 1
//#define DAYLIGHT_SAVINGS
#define MAXDAC 4095
#define SEC_IN_DAY 86400
#define NSTEPS  200//Number of intensity steps from 1V to 10V ballast input
//#define RELATIVE_CLOCK 1 //uncomment if arduino is powered via timer
                         //careful - timer must be on for the entire photoperiod
                         //comment out if it powered 24/7

//Sunrise/sunset/burst parameters. Times are in seconds
#ifndef RELATIVE_CLOCK //------------------------
  #define HRON 15      // SET THE TIME PERIOD HERE
  #define MINON 00     //---------------------------
  #define HROFF 00
  #define MINOFF 00
#else
  #define HRON 00
  #define MINON 00
  #define HROFF 9
  #define MINOFF 30
#endif

//MODLIGHTHRS x 2 + BURSTHRS + 1 + 0.15 should equal the photoperiod in hrs.
#define TRANSITION_MIN 30 //sunrise/sunset transition
#define MODLIGHTHRS 3.0 //will be 2x this - one on each side of burst
#define BURSTHRS 2.0
#define BURST_TRAN_MIN 5 //minutes of burst transition

//Define light intensity for normal/burst periods
#define LSR (0.6*NSTEPS)
#define LB  (0.8*NSTEPS)
#define LSS (0.6*NSTEPS) 


// RANDOM CLOUD COVERAGE PARAMETERS
#define MAXNUMCLOUDS 10
#define MINNUMCLOUDS 5
#define MAXCLOUDMIN 10
#define MAXCLOUDCOVERPCT 15

//for DS1307 RTC 
#include "Wire.h"
#define DS1307_I2C_ADDRESS 0x68
#define DS1307_RAM_BASE 0x08

//arduino output pins
#define LATCH 8 //pin 8 DAC
#define CLOCK 9 //pin 4 DAC
#define DATA  10 //pin 5 DAC
#define CS   11 //pin 3 DAC
//2 uS of clock period (sample rate = 30.3 KHz)
#define HALF_CLOCK_PERIOD 10 //in uS
//------------------------------------------------------------------------- 
 
 
 
///////////////////////////////////////////////////////////////////
//GLOBAL VARIABLES
///////////////////////////////////////////////////////////////////

int ledPin =  13; 
long previousMillis = 0;    


//CLOCK
//MODLIGHTHRS=
long int Ton=((long int)HRON*3600+(long int)MINON*60+00);
long int TSR=(Ton+(long int)TRANSITION_MIN*60);//trans to mod light
long int TBS1=(TSR+(long int)(MODLIGHTHRS*3600)); //begin switch to high light
long int TBS2=(TBS1+(long int)BURST_TRAN_MIN*60); //5min transition to high light
long int TBE1=(TBS2+(long int)(BURSTHRS*3600)); //2 hr noon burst
long int TBE2=(TBE1+(long int)BURST_TRAN_MIN*60); //5 min to moderate light
long int TF=((long int)HROFF*3600+(long int)MINOFF*60); //off time
long int TSS=(TF-(long int)TRANSITION_MIN*60); //start sunset

long int sec; //current time in seconds
byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
byte DST; //binary flag for Daylight Savings Time

//DAC
int dacA, dacB, outA, outB; //dac outputs

//cloud debug
byte firsttime;
byte SCHED_SET=0; //flag for setting cloud schedule

  //random clouds
  int Nclouds;
  long  d[MAXNUMCLOUDS]; 
  long  h[MAXNUMCLOUDS];
  long  t[MAXNUMCLOUDS];  //duration(min), amplitude (pct) and start time (min) of clouds

///////////////////////////////////////////////////////////////////



void setup()
{
  // if analog input pin 0 is unconnected, random analog
  // noise will cause the call to randomSeed() to generate
  // different seed numbers each time the sketch runs.
  // randomSeed() will then shuffle the random function.
  randomSeed(analogRead(0));

  if (TSS<0) TSS=TSS+SEC_IN_DAY; //just in case TSS <0
  
  //DAC setup
  pinMode(DATA, OUTPUT);
  pinMode(CLOCK,OUTPUT);
  pinMode(LATCH,OUTPUT);
  pinMode(CS, OUTPUT);

  pinMode(ledPin, OUTPUT);     
 
  digitalWrite(DATA,LOW);
  digitalWrite(CLOCK,LOW);
  digitalWrite(LATCH,HIGH);
  digitalWrite(CS,HIGH);
  
  
  //dac memory, and set both dac channels to 10%
  dacA=0;
  dacB=0;
  writeValue((uint16_t)(0.1*(float)MAXDAC),0);
  writeValue((uint16_t)(0.1*(float)MAXDAC),1);
  
  Serial.begin(9600);
  Serial.println("Hello");
 
  
  //DS1307 setup
  Wire.begin();
  check_clock_ok(); //check if clock lost power - if so, freeze.
  //DS1307 memory test
  //DST=get_ram_byte(0);
  //Serial.print("DST=");
  //Serial.println(DST,DEC);
  //set_ram_byte(0,DST+1);
  //DST=get_ram_byte(0); 
  //Serial.print("mem after=");
  //Serial.println(DST,DEC);
  //set_ram_byte(0,0x00);
  
  #ifdef RELATIVE_CLOCK //set the time to 0:0:0 - used if powered via timer.
  // Change these values to what you want to set your clock to.
  hour = 0;
  minute = 00;
  second = 00;
  dayOfWeek = 1;
  dayOfMonth = 1;
  month = 1;
  year = 10;
  setDateDs1307(second, minute, hour, dayOfWeek, dayOfMonth, month, year);
  #endif

  
  //if this is a reset in the middle of the photoperiod, set correct light level
  getDateDs1307(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month, &year);
  sec= ((long int)hour*3600+(long int)minute*60+(long int)second);
  //get light levels
  outA=getLightLevel(sec);
  outB=outA;
  //write it on the DAC
  writeValue((uint16_t)((float)outA/(float)NSTEPS*(0.9*MAXDAC)+0.1*(float)MAXDAC),0);
  writeValue((uint16_t)((float)outB/(float)NSTEPS*(0.9*MAXDAC)+0.1*(float)MAXDAC),1);
  
  //firsttime=1;
  SCHED_SET=0;
}
 
 
 
 

 
void loop()
{
  //byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
  
  byte DST; //helps set time change for spring (DST=1)  / fall (DST=0)
  int i;
  float redpct;
  

  
  
  //GET DATE/SET CLOCK if NECESSARY
  
  //get the date
  getDateDs1307(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month, &year); 
  //get DST status
  DST=get_ram_byte(0); 

  //current time of day in seconds
  sec= ((long int)hour*3600+(long int)minute*60+(long int)second); 
  
  
  #ifdef DAYLIGHT_SAVINGS
  //if we are on Fall time and it's the last sunday in march, spring ahead 1 hr
  if ((DST==0) && (dayOfWeek>=1) && (month>=3) && ((dayOfMonth+7)>31) && (hour>3))
  {
     DST=1;
     set_ram_byte(0,DST);
     setDateDs1307(second, minute, hour+1, dayOfWeek, dayOfMonth, month, year);
  }
  //if we are on Spring time and it's last sunday in october, fall back 1 hr
  if ((DST==1) && (dayOfWeek>=1) && (month>=10) && ((dayOfMonth+7)>31) && (hour>3))
  {
     DST=0;
     set_ram_byte(0,DST);
     setDateDs1307(second, minute, hour-1, dayOfWeek, dayOfMonth, month, year);
  } 
  #endif

  
  //GENERATE RANDOM CLOUD SCHEDULE
  //generate schedule in the beginning of photoperiod  
  if ((/*(hour==HRON) &&*/ (SCHED_SET==0)))
  {
    #ifdef DEBUG
    Serial.println("setting clouds...");
    #endif
    SCHED_SET=1;
    //firsttime=0;
    Nclouds=(int) random(MINNUMCLOUDS,MAXNUMCLOUDS);
    //d=(long *) malloc (Nclouds*sizeof(long)); 
    //t=(long *) malloc (Nclouds*sizeof(long)); 
    //h=(long *) malloc (Nclouds*sizeof(long)); 
    

    for (i=0;i<Nclouds;i++)
    {
      d[i]=(long) random((long)1,(long)MAXCLOUDMIN); 
      t[i]=(long) random((long)0,(long)(realsec(TF,Ton)/60));
      h[i]=(long) random((long)3,(long)MAXCLOUDCOVERPCT);           
    }
     //OUTPUT TEXT TO SERIAL
   
   #ifdef DEBUG
    for (i=0;i<Nclouds;i++)
    {
      Serial.println(d[i]);       
    }
    Serial.println("--- Dur -----------");
    for (i=0;i<Nclouds;i++)
    {
      Serial.println(t[i]);       
    }
   Serial.println("--- T on (rel) -----------");
    for (i=0;i<Nclouds;i++)
    {
      Serial.println(h[i]);       
    }
    Serial.println("---H -----------");
    #endif
       
  }
  else if ((hour==(HROFF)))   //clear schedule after lights off
  {
    SCHED_SET=0; 
    Nclouds=0;
   // free(d);
   // free(t);
   // free(h);
   #ifdef DEBUG
   Serial.println("cleared clouds");
   #endif
  }


 

  
  //------------------------------------------------------  
  //blink - THIS IF STATEMENT EXECUTES INFREQUENTLY
  //------------------------------------------------------
  if (millis() - previousMillis > (long) 4900) 
  {
    Serial.println("-------------- New Cycle ---------------");
   // save the last time you blinked the LED 
    previousMillis = millis();   
     
    // blink - set the LED with the ledState of the variable:
    digitalWrite(ledPin, HIGH);   // set the LED on
    delay(100);                  // wait for a second
    digitalWrite(ledPin, LOW);    // set the LED off
    
    
  //COMPUTE LIGHT LEVELS, WRITE TO DAC

  //get % reduction due to clouds
  if (SCHED_SET==1)
  {
    //redpct=1;
    redpct=getCloudReductionPct(sec,t,d,h,Nclouds);   
  }
  else
  {
    redpct=0;
    #ifdef DEBUG
    Serial.println("Setting CR to zero");
    #endif
  }

  //get light levels
  outA=(int)((float)getLightLevel(sec)); 
  #ifdef DEBUG
  Serial.print("outA before reduction: "); Serial.println(outA);
  #endif  
  outA=(int)(outA*(1-redpct/100.0));
  #ifdef DEBUG
  Serial.print("outA after reduction: "); Serial.println(outA);
  #endif  
  outB=outA;
    
  //IF DAC value is different, write it on the DAC
  if (outA!=dacA) {
   dacA=outA;
   writeValue((uint16_t)((float)outA/(float)NSTEPS*(0.9*MAXDAC)+0.1*(float)MAXDAC),0);
  }
  if (outB!=dacB){
   dacB=outB;
   writeValue((uint16_t)((float)outB/(float)NSTEPS*(0.9*MAXDAC)+0.1*(float)MAXDAC),1);
  }

   Serial.println(" ");
   Serial.print("Time now:");
   Serial.print(hour, DEC);
   Serial.print(":");
   Serial.print(minute, DEC);
   Serial.print(":");
   Serial.print(second, DEC);
   Serial.print(", DST:");
   Serial.println(DST, DEC);


    
   Serial.print("Total seconds - hrs:");
   Serial.print((float)sec,0); Serial.print(" - "); Serial.println((float)realsec(sec,Ton)/3600,2);
   Serial.println("-------------");
   Serial.print("Ton:");
   Serial.println((float) Ton/3600,1);
   Serial.print("TSR:");
   Serial.println((float) TSR/3600,1);
   Serial.print("TBS1:");
   Serial.println((float) TBS1/3600,1);
   Serial.print("TBS2:");
   Serial.println((float) TBS2/3600,1);
   Serial.print("TBE1:");
   Serial.println((float) TBE1/3600,1);
   Serial.print("TBE2:");
   Serial.println((float) TBE2/3600,1);
   Serial.print("TSS:");
   Serial.println((float) TSS/3600,1);
   Serial.print("TF:");
   Serial.println((float) TF/3600,1);
   Serial.print("Photoperiod Duration:");
   Serial.println((float) realsec(TF,Ton)/3600,1);
   Serial.print(Nclouds); Serial.println(" clouds at "); 
   for (i=0; i<Nclouds; i++)
   {  
     Serial.print(((float)t[i]/60));
     Serial.print(" ");
   }
   Serial.println("");
   Serial.print("Intensity [0...4095]:");
   Serial.println( (int)((float)outA/NSTEPS*(0.9*MAXDAC)+0.1*MAXDAC), DEC);
   Serial.print("Output A%:");
   Serial.println((float)outA/NSTEPS*100,1);
   Serial.print("CR= "); Serial.println(redpct,2);
 

  }
  
}



///////////////////////////////////////////
//
// Helper functions here
//
/////////////////////////////////////////////



//---------------------------------------------------------------------------
//add up cloud coverage as a percent reduction of current nominal light
//---------------------------------------------------------------------------
float getCloudReductionPct(long int sec, long t[], long d[] , long h[], int Nclouds)
//d and t are relative, in minutes
//h is in percentage 0-100
{
  int j;
  float sumpct=0;
  long tnow; //relative time, in sec
  float tmp;
  
  /*
  Nclouds=3;
  t[0]=0;
  t[1]=(long)t[0]+3;
  t[2]=(long)t[0]+5;

  d[0]=1;
  d[1]=3;
  d[2]=2;

  h[0]=10;
  h[1]=10;
  h[2]=5;  
  */
  if (Nclouds==0)
   return 0;


  //add up all clouds currently active 
  for (j=0;j<Nclouds;j++)  
  { //check whether current time falls within any cloud interval
     
     #ifdef DEBUG
     Serial.print("Time on:");Serial.print(t[j]);Serial.print("/ Dur: "); Serial.print(d[j]);
     Serial.print(" Min (rel):");
     Serial.println(realsec(sec,Ton)/60);
     Serial.println("ready to add ...");
     #endif
    tnow=realsec(sec,Ton);
    if ((t[j]*60<=tnow) && (t[j]*60+d[j]*60>=tnow))
    {
      //compute % reduction using simple inverted quadratic function
      tmp=(((float)tnow-((float)t[j]*60+(float)d[j]*60/2))/((float)d[j]*60/2));
      sumpct=sumpct-(float)(tmp*tmp*(float)h[j]-(float)h[j]);     
      //Serial.print("Total=");   
      //Serial.println(sumpct,DEC);
    }   
  }
  return sumpct;
}
 

////////////////////////////////////////////////////////////
//
// sunrise/burst/sunset function
// Returns a percentage of desired light intensity
///////////////////////////////////////////////////////////
int getLightLevel(long int sec_raw)
{
 long int offset=0; 
 //long int base0sec;
 long int sec=sec_raw;
 
 if (TF<Ton) //light period is crossing the midnight mark
 {
   offset=(long int)24*3600; //seconds in a day   
 }
 
   sec=sec-Ton; //make all times relative to Ton.
  // Serial.println((float)sec);
  if (sec<0)
    sec=sec+offset;
  
   /*
   Serial.println((float)sec);
   Serial.println((float)TF+offset-Ton);
   Serial.println((float)realsec(TSS,Ton));
   Serial.println((float)realsec(TF,Ton));  
   */
 
  if  (sec>=TF-Ton+offset) //night time !
     {
     //Serial.println("Night");
     return (int) 0;
     }
  else if (sec>=0 &&sec<realsec(TSR,Ton)) //sunrise !
     {
     Serial.println("Sunrise");
     return (int) (sec)*(LSR-0)/realsec(TSR,Ton);
     }
  else if (sec>=realsec(TSR,Ton) && sec<realsec(TBS1,Ton)) //moderate light !
     {
     Serial.println("On Moderate");
     return (int) LSR;
     }
 else if (sec>=realsec(TBS1,Ton) &&sec<realsec(TBS2,Ton)) //rising to noon burst !
     {
     Serial.println("Burst rise");
     return (int) (LSR+(sec-realsec(TBS1,Ton))*(LB-LSR)/realsec(TBS2,TBS1));
     }
 else if (sec>=realsec(TBS2,Ton) &&sec<realsec(TBE1,Ton)) //noon burst
     {
      Serial.println("Burst on");
      return (int) LB;
     }
 else if (sec>=realsec(TBE1,Ton) &&sec<realsec(TBE2,Ton)) //falling from noon burst
     {
     Serial.println("Burst falling");
     return (int) (LB+(sec-realsec(TBE1,Ton))*(LSS-LB)/realsec(TBE2,TBE1));
     }
 else if (sec>=realsec(TBE2,Ton) && sec<realsec(TSS,Ton)) //moderate light
     {
     Serial.println("on Moderate A/B");
     return (int) LSS;
     }
 else if (sec>=realsec(TSS,Ton) && sec<realsec(TF,Ton)) //sunset
     {
     Serial.println("Sunset");
     //Serial.println(realsec(sec+offset,TSS));
     //Serial.println(realsec(TF,TSS));
     return (int) (LSS+(sec-realsec(TSS,Ton))*(0-LSS)/realsec(TF,TSS));
     }
  else
     {
     Serial.println("Oops!");
     }
 
}



  
//return seconds passed, taking into account possible date
//changes between t1, t2. 
float realsec(long int t2, long int t1)
{
  //long int test=0;
  //Serial.print("T2:");
  //Serial.println((float)t2,2);
  // Serial.print("T1:");
  // Serial.println((float)t1,2);

  if (t1<=t2) //date change between Ton-TSR
   return (float)(t2-t1);
  else
    {
      //test=
      //Serial.println((float)test,2);
      return (float)(t2-t1)+SEC_IN_DAY;
    }
}


////////////////////////////////////////////////////////////
//DAC writing
///////////////////////////////////////////////////////////////
void writeValue(uint16_t value, uint8_t AorB){
 
  #define BUFF 0
  #define GAIN 1
  #define NoSHDN   1
  //B=1 --> 2^15=32768
  //BUFF--> 2^14=16384
  //GA=1--> 2^13=8192
  //NoSHDN->2^12=4096
    
  uint16_t command=0;
  
  command=command+AorB*32768+BUFF*16384+GAIN*8192+NoSHDN*4096;
  command=command+value;
  //Serial.println(command);

  //start of sequence
  digitalWrite(LATCH,HIGH);
  digitalWrite(CS,LOW);
  digitalWrite(CLOCK,LOW);
 
  //send the 12 bit sample data
  for(int i=15;i>=0;i--){
    digitalWrite(DATA,((command&(1<<i)))>>i);
    //Serial.println(((command&(1<<i)))>>i);
    delayMicroseconds(HALF_CLOCK_PERIOD);
    digitalWrite(CLOCK,HIGH);
    delayMicroseconds(HALF_CLOCK_PERIOD);
    digitalWrite(CLOCK,LOW);
  }
 
  //latch enable, DAC output is set
  //digitalWrite(DATA,LOW);
  digitalWrite(CLOCK,LOW);
  digitalWrite(CS,HIGH);
  digitalWrite(LATCH,LOW);
  delayMicroseconds(HALF_CLOCK_PERIOD);
  digitalWrite(LATCH,HIGH);
 
}
 
 
 
////////////////////////////////////////////////////////////
//DS1307 functions
///////////////////////////////////////////////////////////////
// Convert normal decimal numbers to binary coded decimal
byte decToBcd(byte val)
{
  return ( (val/10*16) + (val%10) );
}

// Convert binary coded decimal to normal decimal numbers
byte bcdToDec(byte val)
{
  return ( (val/16*10) + (val%16) );
}


// Gets the date and time from the ds1307
void getDateDs1307(byte *second,
          byte *minute,
          byte *hour,
          byte *dayOfWeek,
          byte *dayOfMonth,
          byte *month,
          byte *year)
{
  // Reset the register pointer
  Wire.beginTransmission(DS1307_I2C_ADDRESS);
  Wire.send(0);
  Wire.endTransmission();

  Wire.requestFrom(DS1307_I2C_ADDRESS, 7);

  // A few of these need masks because certain bits are control bits
  *second     = bcdToDec(Wire.receive() & 0x7f);
  *minute     = bcdToDec(Wire.receive());
  *hour       = bcdToDec(Wire.receive() & 0x3f);  // Need to change this if 12 hour am/pm
  *dayOfWeek  = bcdToDec(Wire.receive());
  *dayOfMonth = bcdToDec(Wire.receive());
  *month      = bcdToDec(Wire.receive());
  *year       = bcdToDec(Wire.receive());
}


// 1) Sets the date and time on the ds1307
// 2) Starts the clock
// 3) Sets hour mode to 24 hour clock
// Assumes you're passing in valid numbers
void setDateDs1307(byte second,        // 0-59
                   byte minute,        // 0-59
                   byte hour,          // 1-23
                   byte dayOfWeek,     // 1-7
                   byte dayOfMonth,    // 1-28/29/30/31
                   byte month,         // 1-12
                   byte year)          // 0-99
{
   Wire.beginTransmission(DS1307_I2C_ADDRESS);
   Wire.send(0);
   Wire.send(decToBcd(second));    // 0 to bit 7 starts the clock
   Wire.send(decToBcd(minute));
   Wire.send(decToBcd(hour));      // If you want 12 hour am/pm you need to set
                                   // bit 6 (also need to change readDateDs1307)
   Wire.send(decToBcd(dayOfWeek));
   Wire.send(decToBcd(dayOfMonth));
   Wire.send(decToBcd(month));
   Wire.send(decToBcd(year));
   Wire.endTransmission();
}



 void check_clock_ok()
  {
  // Make sure the clock has valid data
  Wire.beginTransmission( DS1307_I2C_ADDRESS);
  Wire.send(0x00);
  Wire.endTransmission();
  Wire.requestFrom( DS1307_I2C_ADDRESS, 1);
  byte runningflag = Wire.receive();
  
  // Make sure that at least the clock didn't lose power
  // by checking the CH (Clock Halt) flag
  if (runningflag & (1<<7)) {
    Serial.println("ERROR: RTC DEAD!");
    // We don't want to do anything without valid data
    int ledflag = 1;
    while (1) {
      delay(1000);
      digitalWrite(ledPin, ledflag = !ledflag);
    }
   }  
  }
  
  
  void set_ram_byte(int idx, byte val)
  {
  //SET RAM BYTE
  ////////////////////////////////////////////////////////
    Wire.beginTransmission(DS1307_I2C_ADDRESS);
    Wire.send(DS1307_RAM_BASE+idx);
    Wire.send(val);
    Wire.endTransmission();
  }

  byte get_ram_byte(int idx)
  {
   // GET RAM BYTE
   //////////////////////////////////////////
   Wire.beginTransmission(DS1307_I2C_ADDRESS);
   Wire.send(DS1307_RAM_BASE+idx);
   Wire.endTransmission();
   Wire.requestFrom(DS1307_I2C_ADDRESS, 1);  
   return (Wire.receive());
  }
  
  
