<?php
/*
+---------------------------------------------------------------
| vBulletin Board to FireBoard Converter (vb2fbConvertor)
| Version 1.0
| (C) 2007 BBPIXEL.COM. All Rights Reserved
+---------------------------------------------------------------
*/

function GetParam($key, $defaultValue = null){
	global $ParamsList;
	
	if(isset($ParamsList[$key])){
		return $ParamsList[$key];
	}else {
		return $defaultValue;
	}
}

function GetParams(){	
	$return = array();
	
	if( is_array($_GET) ){
		while( list($k, $v) = each($_GET) ){
			if ( is_array($_GET[$k]) ){
				while( list($k2, $v2) = each($_GET[$k]) ){
					$return[ _CleanKey($k) ][ _CleanKey($k2) ] = _CleanValue($v2);
				}
			}else{
				$return[ _CleanKey($k) ] = _CleanValue($v);
			}
		}
	}

	// Overwrite GET data with post data
	if( is_array($_POST) ){
		while( list($k, $v) = each($_POST) ){
			if ( is_array($_POST[$k]) ){
				while( list($k2, $v2) = each($_POST[$k]) ){
					$return[ _CleanKey($k) ][ _CleanKey($k2) ] = _CleanValue($v2);
				}
			}else{
				$return[ _CleanKey($k) ] = _CleanValue($v);
			}
		}
	}
	
	$return['request_method'] = strtolower($_SERVER['REQUEST_METHOD']);    
	return $return;
}


function _CleanKey($key){
	if ($key == ""){
		return "";
	}  	
	$key = htmlspecialchars(urldecode($key));
	$key = preg_replace( "/\.\./"           , ""  , $key );
	$key = preg_replace( "/\_\_(.+?)\_\_/"  , ""  , $key );
	$key = preg_replace( "/^([\w\.\-\_]+)$/", "$1", $key );  	
	return $key;
}


function _CleanValue($val){		    	
	if ($val == ""){
		return "";
	}    
	$val = str_replace( "&#032;", " ", $val );
	//strip space char
	$val = str_replace( chr(0xCA), "", $val );  //Remove sneaky spaces
	//another char        
	$val = str_replace( "&"            , "&amp;"         , $val );
	$val = str_replace( "<!--"         , "&#60;&#33;--"  , $val );
	$val = str_replace( "-->"          , "--&#62;"       , $val );
	$val = preg_replace( "/<script/i"  , "&#60;script"   , $val );
	$val = str_replace( ">"            , "&gt;"          , $val );
	$val = str_replace( "<"            , "&lt;"          , $val );
	$val = str_replace( "\""           , "&quot;"        , $val );
	$val = preg_replace( "/\n/"        , "<br />"        , $val ); // Convert literal newlines
	$val = preg_replace( "/\\\$/"      , "&#036;"        , $val );
	$val = preg_replace( "/\r/"        , ""              , $val ); // Remove literal carriage returns
	$val = str_replace( "!"            , "&#33;"         , $val );
	$val = str_replace( "'"            , "&#39;"         , $val ); // IMPORTANT: It helps to increase sql query safety.
	
	// Ensure unicode chars are OK    
	//..allow unicode    
	$val = preg_replace("/&amp;#([0-9]+);/s", "&#\\1;", $val );   
	
	// Strip slashes if not already done so
	$getMagicQuotes = get_magic_quotes_gpc();
	if ( $getMagicQuotes ){
		$val = stripslashes($val);
	}
	
	// Swop user inputted backslashes    
	$val = preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $val );     
	return $val;
}


function CreateUserSalt($length = 3){
	$salt = '';
	for ($i = 0; $i < $length; $i++){
		$salt .= chr(rand(32, 126));
	}
	return $salt;
}


function ConvertArray2Bits(&$arry, $_FIELDNAMES, $unset = 0){
	$bits = 0;
	foreach($_FIELDNAMES AS $fieldname => $bitvalue){
		if ($arry["$fieldname"] == 1){
			$bits += $bitvalue;
		}
		if ($unset){
			unset($arry["$fieldname"]);
		}
	}
	return $bits;
}
?>