<?php
/*
+---------------------------------------------------------------
| vBulletin Board to FireBoard Converter (vb2fbConvertor)
| Version 1.0
| (C) 2007 BBPIXEL.COM. All Rights Reserved
+---------------------------------------------------------------
*/

//Action Functions
function DeleteJoomData(){
	global $DB;
	//Delete data from
	//..jos_core_acl_groups_aro_map
	$DB->simple_delete(_JoomTbl('core_acl_groups_aro_map'), false);
	$DB->simple_exec();
	//..jos_core_acl_aro
	$DB->simple_delete(_JoomTbl('core_acl_aro'), false);
	$DB->simple_exec();
	//..jos_users
	$DB->simple_delete(_JoomTbl('users'), false);
	$DB->simple_exec();
	
	//..jos_fb_messages_text
	$DB->simple_delete(_JoomTbl('fb_messages_text'), false);
	$DB->simple_exec();
	//..jos_fb_messages
	$DB->simple_delete(_JoomTbl('fb_messages'), false);
	$DB->simple_exec();
	//..jos_fb_categories
	$DB->simple_delete(_JoomTbl('fb_categories'), false);
	$DB->simple_exec();
	//..jos_fb_moderation
	$DB->simple_delete(_JoomTbl('fb_moderation'), false);
	$DB->simple_exec();
	//..jos_fb_fb_users
	$DB->simple_delete(_JoomTbl('fb_users'), false);
	$DB->simple_exec();
	
	//Show message
	PrintRedirectForm("?act=createjoomuser", "Delete data from tables completed successful", 3);
}

function CreateJoomUser(){
	global $DB, $globalLoopTimes;
	$previousID = intval(GetParam("userid", 0));
	//Fix Jun 11: support posts counter
	$query = "SELECT u.userid as id, u.username, u.username as name, u.email, u.password, u.joindate, u.lastvisit as lastvisitDate, u.posts, ut.signature
		FROM "._vBTbl('user')." u 
		LEFT JOIN "._vBTbl('usertextfield')." ut ON(u.userid=ut.userid) 
		WHERE u.userid > $previousID ORDER BY u.userid ASC LIMIT 0, {$globalLoopTimes}";
	$qResult = $DB->query($query);
	$rowCounter = $DB->get_num_rows();
	if($rowCounter > 0){
		$lastUserId = 0;
		while($vbAccount = $DB->fetch_row($qResult)){
			_CreateJoomAccount($vbAccount);
			$lastUserId = $vbAccount['id'];
		}
		PrintRedirectForm("?act=do_createjoomuser&userid={$lastUserId}", "{$rowCounter} users have been inserted to Joomla. Finding more to insert", 3);
	}else {
		PrintRedirectForm("?act=createcat", "Copy users from vBulletin completed successful", 3);
	}	
}

function CreateFBCategory(){
	global $DB, $globalLoopTimes;
	$previousID = intval(GetParam("forumid", 0));
	$query = "SELECT forumid as id, title as name, description, displayorder as ordering, parentid as parent
		FROM "._vBTbl('forum')." 
		WHERE forumid>{$previousID} ORDER BY forumid ASC
		LIMIT 0, {$globalLoopTimes}";
	$qResult = $DB->query($query);
	$rowCounter = $DB->get_num_rows();
	if($rowCounter > 0){
		$lastForumId = 0;
		while($row = $DB->fetch_row($qResult)){
			_CreateFireBoardCategory($row);
			$lastForumId = $row['id'];
		}
		PrintRedirectForm("?act=do_createcat&forumid={$lastForumId}", "{$rowCounter} forums have been inserted to FireBoard. Finding more to insert", 3);
	}else {
		PrintRedirectForm("?act=createtopicthread", "Copy forum structure completed successful", 3);
	}	
}

function CreateFBTopicFromVbThread(){
	global $DB, $globalLoopTimes;
	$previousID = intval(GetParam("threadid", 0));
	//Fix Jun 11: name is username, not topic title
	$query = "SELECT th.threadid as id, '0' as parent, th.threadid as thread, th.forumid as catid, u.username as name,
			th.postuserid as userid, u.email, 
			th.title as subject, th.dateline as time, '172.1.0.0' as ip, th.open as locked, th.sticky as stick, '0' as ordering,
			th.views as hits, '0' as moved
		FROM "._vBTbl('thread')." th LEFT JOIN "._vBTbl('user')." u
			ON (th.postuserid = u.userid)
		WHERE th.threadid>{$previousID} ORDER BY th.threadid ASC
		LIMIT 0, {$globalLoopTimes}";
	$qResult = $DB->query($query);
	$rowCounter = $DB->get_num_rows();
	if($rowCounter > 0){
		$lastThreadId = 0;
		while($row = $DB->fetch_row($qResult)){
			$row['locked'] = 1 - $row['locked'];
			_CreateFireBoardTopic($row);
			$lastThreadId = $row['id'];
		}
		PrintRedirectForm("?act=do_createtopicthread&threadid={$lastThreadId}", "{$rowCounter} threads have been inserted to FireBoard. Finding more to insert", 3);
	}else {
		PrintRedirectForm("?act=createtopicpost", "Copy threads completed successful", 3);
	}	
}


function CreateFBTopicFromVbPost(){
	global $DB, $globalLoopTimes;
	$previousID = intval(GetParam("postid", 0));
	//Fix Jun 11: name is username, not topic title!
	$query = "SELECT p.postid as id, p.parentid as parent, p.threadid as thread, th.forumid as catid, u.username as name,
		p.userid, u.email, 
		th.title as subject, p.dateline as time, p.ipaddress as ip, th.open as locked, th.sticky as stick, '0' as ordering,
		th.views as hits, '0' as moved, 
		p.pagetext as message
		FROM "._vBTbl('post')." p INNER JOIN "._vBTbl('thread')." th ON (p.threadid = th.threadid) 
		LEFT JOIN "._vBTbl('user')." u ON (p.userid = u.userid)
		WHERE p.postid > {$previousID} ORDER BY p.postid ASC
		LIMIT 0, {$globalLoopTimes}";
	
	$qResult = $DB->query($query);
	$rowCounter = $DB->get_num_rows();
	if($rowCounter > 0){
		$lastThreadId = 0;
		while($row = $DB->fetch_row($qResult)){
			//Thread content? so we do not need to create a new topic?
			if(intval($row['parent']) > 0){
				$row['locked'] = 1 - $row['locked'];
				$topicId = _CreateFireBoardTopic($row, true);	
				$row['mesid'] = $topicId;
			}else {
				$row['mesid'] = $row['thread'];
			}						
			_CreateFireBoardPost($row);
			$lastPostId = $row['id'];
		}
		PrintRedirectForm("?act=do_createtopicpost&postid={$lastPostId}", "{$rowCounter} topics and posts have been inserted to FireBoard. Finding more to insert", 3);
	}else {
		PrintRedirectForm("?act=createmoderator", "Copy posts completed successful", 3);
	}	
}


function CreateFBModerator(){
	global $DB;
	
	$query = "SELECT userid, forumid as catid FROM "._vBTbl('moderator');
	$qResult = $DB->query($query);
	$rowCounter = $DB->get_num_rows();
	if($rowCounter > 0){
		while ($row = $DB->fetch_row($qResult)){
			_CreateFireBoardModeration($row);
			
		}
	}
	PrintRedirectForm("?act=setjoomadmin", "Copy moderations ($rowCounter) completed successful", 3);
}


function SetJoomAdmin(){
	global $DB;
	$username = addslashes(GetParam('username', ''));
	$password = addslashes(GetParam('password', ''));	
	if(strlen($username)==0 || strlen($password)==0){
		PrintRedirectForm("?act=setjoomadmin", "Please input a username and password", 3);
	}
	$query = "SELECT id FROM "._JoomTbl('users')." WHERE username LIKE '{$username}' LIMIT 1";	
	$DB->query($query);
	$rowCounter = $DB->get_num_rows();
	if($rowCounter > 0){
		$user = $DB->fetch_row($qResult);
		$md5Password = md5($password);
		//Set new pwd, group for this account
		$query = "UPDATE "._JoomTbl('users')." 
			SET 
				password='{$md5Password}',
				usertype='Super Administrator',
				gid='25'
			WHERE id='{$user['id']}'";
		$DB->query($query);
		
		//Update its group, to be a Super Administrtor
		$query = "SELECT aro_id FROM "._JoomTbl('core_acl_aro')."
    	  WHERE value='{$user['id']}'
    	  LIMIT 1";
		$qResult = $DB->query($query);
		$aro = $DB->fetch_row($qResult);
		$aroId    = $aro['aro_id'];
		if(intval($aroId) == 0){
			PrintRedirectForm("?act=setjoomadmin", "Failing when try to get Joomla AroID for username 
				<b>{$username}</b> with id = <b>{{$user['id']}}</b>. Try with another account, please", 5);	
		}else {
			$query = "UPDATE "._JoomTbl('core_acl_groups_aro_map')."
				SET group_id='25'
				WHERE aro_id='{$aroId}' LIMIT 1";
			$DB->query($query);
		}
		PrintRedirectForm("?act=final", "Update admin user completed successful", 3);
	}else {
		PrintRedirectForm("?act=setjoomadmin", "Cannot find <b>{$username}</b> in Joomla users table", 5);	
	}
}

function _CreateFireBoardModeration($mod){
	global $DB;
	//Insert to FireBoard Moderation
	$query = "INSERT INTO "._JoomTbl('fb_moderation'). " (catid, userid)
		VALUES(
			'{$mod['catid']}',
			'{$mod['userid']}'
		)";	
	$DB->query($query);
	//Update FireBoard forum
	$query = "UPDATE "._JoomTbl('fb_categories')." 
		SET
			moderators='1'
		WHERE
			id='{$mod['catid']}'";
	$DB->query($query);
	
	//Fix Jun 11: Update FireBoard user
	$query = "UPDATE "._JoomTbl('fb_users')." 
		SET
			moderator='1'
		WHERE
			userid='{$mod['userid']}'";
	$DB->query($query);
}

function _CreateFireBoardPost(&$post){
	global $DB;
	//premake data
	$post['message'] = addslashes($post['message']);
	
	$query = "INSERT INTO "._JoomTbl('fb_messages_text')." (mesid, message)
		VALUES (
			'{$post['mesid']}',
			'{$post['message']}'
		)";
	$DB->query($query);
}


function _CreateFireBoardTopic(&$topic, $newId=false){
	global $DB;
	//Premake data
	$topic['subject']	= addslashes($topic['subject']);
	$topic['name']		= addslashes($topic['name']);
	$id = $topic['id'];
	if($newId){
		$id = '';
	}
	//Fix Jun 11: 
	// - name is username, not message title!
	// - hold is not sticky :(
	$query = "INSERT INTO "._JoomTbl('fb_messages')." (
			id, parent, thread, catid, name, 
			userid, email, 
			subject, time, ip, locked, hold, ordering, 
			hits, moved)
		VALUES(
			'{$id}','{$topic['parent']}','{$topic['thread']}','{$topic['catid']}','{$topic['name']}',
			'{$topic['userid']}','{$topic['email']}',
			'{$topic['subject']}','{$topic['time']}','{$topic['ip']}','{$topic['locked']}','0','{$topic['ordering']}',
			'{$topic['hits']}','{$topic['moved']}'
		)";
	$DB->query($query);
	return $DB->get_insert_id();
}


function _CreateFireBoardCategory(&$cat){
	global $DB, $globalPublicAccess, $globalPublicRecurse, $globalAdminAccess, $globalAdminRecurse, $globalForumReview;
	
	//Premake data
	$cat['name'] 		= addslashes($cat['name']);
	$cat['description'] = addslashes($cat['description']);
	if(intval($cat['parent']) < 0){
		$cat['parent'] = 0;
	}
	
	$query = "INSERT INTO "._JoomTbl('fb_categories')." (id, parent, name, description, published, pub_access, pub_recurse, admin_access, admin_recurse, review, ordering)
		VALUES(
			'{$cat['id']}',
			'{$cat['parent']}',
			'{$cat['name']}',
			'{$cat['description']}',
			'1',
			'{$globalPublicAccess}',
			'{$globalPublicRecurse}',
			'{$globalAdminAccess}',
			'$globalAdminRecurse',
			'$globalForumReview',
			'{$cat['ordering']}'
		)";
	$DB->query($query);
}


function _CreateJoomAccount(&$acount){
	global $DB, $globalEmailForEmpty;
	//Premake data	
	$acount['name']			= addslashes($acount['name']);
	$acount['username']		= addslashes($acount['username']);
	$acount['username']		= addslashes($acount['username']);// :D ?
	//Fix Jun 11: for some vBulletin which empty email account
	if(strlen($acount['email']) < 2){
		$acount['email'] 	= $globalEmailForEmpty;
	}
	$joined 				= date("Y-m-d\TH:i:s",$acount['joined']);
	$lastvisitDate 			= date("Y-m-d\TH:i:s",$acount['lastvisitDate']);
	
	//Inset to jos_users
	$query = "INSERT INTO "._JoomTbl('users')." (id, name, username, email, password, usertype, block, sendEmail, gid, registerDate,lastvisitDate, params)
		VALUES (
			'{$acount['id']}',
			'{$acount['name']}',
			'{$acount['username']}',
			'{$acount['email']}',
			'{$acount['password']}',
			'Registered',
			'0',
			'1',
			'18',
			'{$joined}',
			'{$lastvisitDate}',
			''
		)";
	$DB->query($query);
	
	//And its jos_core_acl_aro
	$query = "INSERT INTO "._JoomTbl('core_acl_aro')." (aro_id, section_value, value, order_value, name, hidden)
		VALUES ('{$acount['id']}',
			'users',
			'{$acount['id']}',
			'0',
			'{$acount['name']}',
			'0'
			)";
	$DB->query($query);

	//Also jos_acl_griyps_aro_map
	$aro_id    = $DB->get_insert_id();
	$group_id	= 18;//Hard code? Id of "Registered" group
	$query = "INSERT INTO "._JoomTbl('core_acl_groups_aro_map')."
		VALUES ('{$group_id}','','{$aro_id}'
		)";
	$DB->query($query);
	
	//Then, jos_fb_users, for user signature
	if( ($acount['signature']!=null) && (strlen($acount['signature']) > 0) ){
		$acount['signature'] = addslashes($acount['signature'].""); //Fix Jun 12
	}
	$query = "INSERT INTO "._JoomTbl('fb_users')." (userid, signature, posts)
		VALUES(
			'{$acount['id']}',
			'{$acount['signature']}',
			'{$acount['posts']}'
		)";
	$DB->query($query);
}


function _JoomTbl($tableName){
	global $globalJoomPrefix;
	return $globalJoomPrefix.$tableName;
}

function _vBTbl($tableName){
	global $globalvBPrefix;
	return $globalvBPrefix.$tableName;
}
?>